<form action="{{ route('staffs.updatepageprivilege', $privilege->PAGEID) }}" method="POST">
    @csrf

    <div class="modal-body">
        <h5 class="mb-3">Teacher: <b>{{ $teacher->Name }}</b></h5>

        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead class="table-light text-center">
                    <tr>
                        <th>Module</th>
                        <th>View</th>
                        <th>Edit</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $modules = [
                            'attendance' => 'Attendance',
                            'mark' => 'Marks',
                            'entry_exit_card' => 'Entry/Exit Card',
                            'healthcard' => 'Health Card',
                            'event' => 'Event',
                            'leave' => 'Leave',
                            'payment' => 'Payment',
                        ];
                    @endphp


                    @foreach ($modules as $key => $label)
                        <tr>
                            <td>{{ $label }}</td>
                            <td class="text-center">
                                <input type="checkbox" name="{{ $key }}_view" value="1"
                                       {{ $privilege[$key . '_view'] ? 'checked' : '' }}>
                            </td>
                            <td class="text-center">
                                <input type="checkbox" name="{{ $key }}_edit" value="1"
                                       {{ $privilege[$key . '_edit'] ? 'checked' : '' }}>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <div class="modal-footer">
        <button type="button" class="btn btn-danger btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success btn-sm">Update Privileges</button>
    </div>
</form>
