<form action="{{ url('staffs/assignedclasses/'.$id) }}" method="POST">
    @csrf
    <div class="box">
        <div class="box-body" id="rows-container">
            @php 
                $allotedclass = json_decode($teacher->tech_class, true);
                $hasClasses = !empty($allotedclass);
            @endphp

            @if($hasClasses)
                @foreach($allotedclass as $index => $assigned)
                    <div class="row {{ $index > 0 ? 'mt-2' : '' }}">
                        <!-- Class Dropdown -->
                        <div class="col-md-5">
                            <div class="form-group">
                                <label class="form-label">Class Name</label>
                                <select name="classId[]" class="form-control">
                                    <option value="">Select Class</option>
                                    @foreach($className as $class)   
                                        <option value="{{ $class->classId }}" {{ $assigned['class'] == $class->classId ? 'selected' : '' }} required>
                                            {{ $class->className }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Division Dropdown -->
                        <div class="col-md-5">
                            <div class="form-group">
                                <label class="form-label">Division</label>
                                <select name="secId[]" class="form-control" data-selected="{{ $assigned['division'] }}" required>
                                    <option value="">Select Division</option>
                                </select>
                            </div>
                        </div>

                        <!-- Button -->
                        <div class="col-md-2 d-flex align-items-end">
                            @if($index == count($allotedclass) - 1)
                                <button type="button" class="btn btn-success btn-sm" onclick="addRow(this)">
                                    <i class="fas fa-plus"></i> 
                                </button>
                            @else
                                <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">
                                    <i class="fas fa-minus"></i> 
                                </button>
                            @endif
                        </div>
                    </div>
                @endforeach
            @else
                <div class="row">
                    <!-- Class Dropdown -->
                    <div class="col-md-5">
                        <div class="form-group">
                            <label class="form-label">Class Name</label>
                            <select name="classId[]" class="form-control" required>
                                <option value="">Select Class</option>
                                @foreach($className as $class)   
                                    <option value="{{ $class->classId }}">{{ $class->className }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <!-- Division Dropdown -->
                    <div class="col-md-5">
                        <div class="form-group">
                            <label class="form-label">Division</label>
                            <select name="secId[]" class="form-control" required>
                                <option value="">Select Division</option>
                            </select>
                        </div>
                    </div>

                    <!-- Add button -->
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="button" class="btn btn-success btn-sm" onclick="addRow(this)">
                            <i class="fas fa-plus"></i> 
                        </button>                
                    </div>
                </div>
            @endif
        </div>
    </div>  

    <div class="modal-footer">
        <button type="button" class="btn btn-primary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success btn-sm">Save changes</button>
    </div>
</form>

<script>
// 🔹 Load divisions function
function getDivisions(classId, divisionDropdown, selectedValue = null) {
    if (!classId) {
        divisionDropdown.html('<option value="">-- Select Division --</option>');
        return;
    }

    var url = "{{ url('/') }}/getDivisions/" + classId;

    $.get(url)
        .done(function(data) {
            divisionDropdown.empty();
            divisionDropdown.append('<option value="">-- Select Division --</option>');
            $.each(data, function(index, division) {
                var isSelected = selectedValue && division.id == selectedValue ? 'selected' : '';
                divisionDropdown.append(`<option value="${division.id}" ${isSelected}>${division.name}</option>`);
            });
        });
}

// 🔹 Ensure last row always has + AND - buttons
function updateButtons() {
    let rows = $('#rows-container .row');
    rows.each(function(index) {
        let buttonsDiv = $(this).find('.col-md-2');
        buttonsDiv.html(''); // clear buttons

        // If only one row → only show +
        if (rows.length === 1) {
            buttonsDiv.append(`
                <button type="button" class="btn btn-success btn-sm" onclick="addRow(this)">
                    <i class="fas fa-plus"></i>
                </button>
            `);
        } else {
            // All rows get "-"
            buttonsDiv.append(`
                <button type="button" class="btn btn-danger btn-sm me-1" onclick="removeRow(this)">
                    <i class="fas fa-minus"></i>
                </button>
            `);

            // Only last row gets "+"
            if (index === rows.length - 1) {
                buttonsDiv.append(`
                    <button type="button" class="btn btn-success btn-sm" onclick="addRow(this)">
                        <i class="fas fa-plus"></i>
                    </button>
                `);
            }
        }
    });
}

// 🔹 Add Row
function addRow(button) {
    var classDropdown = $('select[name="classId[]"]').first().clone(); 
    var divisionDropdown = $('select[name="secId[]"]').first().clone(); 
    
    // Reset the class dropdown properly
    classDropdown.val('');
    classDropdown.find('option').removeAttr('selected');
    classDropdown.find('option[value=""]').attr('selected', 'selected');
    classDropdown.removeAttr('data-selected');
    
    // Reset division dropdown
    divisionDropdown.html('<option value="">Select Division</option>');
    divisionDropdown.removeAttr('data-selected');

    var newRow = `
        <div class="row mt-2">
            <div class="col-md-5">
                <div class="form-group">
                    <label class="form-label">Class Name</label>
                    ${classDropdown.prop('outerHTML')}
                </div>
            </div>
            <div class="col-md-5">
                <div class="form-group">
                    <label class="form-label">Division</label>
                    ${divisionDropdown.prop('outerHTML')}
                </div>
            </div>
            <div class="col-md-2 d-flex align-items-end"></div>
        </div>
    `;

    $('#rows-container').append(newRow);
    updateButtons();
}

// 🔹 Remove Row
function removeRow(button) {
    if ($('#rows-container .row').length <= 1) {
        alert("At least one class assignment is required!");
        return;
    }

    $(button).closest('.row').remove();
    updateButtons();
}

// 🔹 Load pre-selected divisions
$(document).ready(function() {
    $('select[name="classId[]"]').each(function() {
        var classId = $(this).val();
        var divisionDropdown = $(this).closest('.row').find('select[name="secId[]"]');
        var selectedDivision = divisionDropdown.data('selected');
        if (classId) {
            getDivisions(classId, divisionDropdown, selectedDivision);
        }
    });

    updateButtons();
});

// 🔹 Load divisions when class changes
$(document).on('change', 'select[name="classId[]"]', function() { 
    var classId = $(this).val(); 
    var divisionDropdown = $(this).closest('.row').find('select[name="secId[]"]'); 
    getDivisions(classId, divisionDropdown); });
</script>
