@extends('index')

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <div class="container-fluid">
            <!-- Page Title -->
            <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                <h4 class="page-title">{{ $title }}</h4>
                <div>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="#">Admin</a></li>
                        <li class="breadcrumb-item active">Settings</li>
                    </ol>
                </div>
            </div>

            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            @include('layouts.flashmessages')
                        </div>
                        <div class="card-body">
                            <form action="{{ route('settings') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
    <!-- Main Logo -->
            <div class="form-group col-md-4">
                <label for="main_logo" class="col-form-label text-center">Main Logo</label><br>
                <input 
                type="file" 
                name="main_logo" 
                class="form-control dropify"
                accept="image/png, image/jpeg, image/jpg"
                data-allowed-file-extensions="jpg jpeg png"
                data-default-file="{{ isset($settings->main_logo) ? asset('assets/images/' . $settings->main_logo) : '' }}">
            </div>
    <!-- Favicon -->
            <div class="form-group col-md-4">
                <label for="favicon" class="col-form-label text-center">Logo</label><br>
                <input type="file" name="icon" class="form-control dropify"accept="image/png, image/jpeg, image/jpg"
                    data-allowed-file-extensions="jpg jpeg png"
                    data-default-file="{{ isset($settings->logo) ? asset('assets/images/' . $settings->logo) : '' }}" >
            </div>


            <div class="row mt-4">
            <!-- Email -->
                <div class="form-group col-md-4">
                    <label for="email" class="col-form-label text-center">Email</label>
                    <input type="email" name="email" id="email" class="form-control" placeholder="Enter email address"
                    value="{{ old('email', $settings->email ?? '') }}">
            </div>

    <!-- Phone -->
    <div class="form-group col-md-4">
        <label for="phone" class="col-form-label text-center">Phone</label>
        <input type="text" 
               name="phone" 
               id="phone" 
               class="form-control" 
               placeholder="Enter phone number"
               value="{{ old('phone', $settings->phone ?? '') }}">
    </div>

    <!-- Address -->
    <div class="form-group col-md-4">
        <label for="address" class="col-form-label text-center">Address</label>
        <textarea name="address" 
                  id="address" 
                  rows="2" 
                  class="form-control" 
                  placeholder="Enter address">{{ old('address', $settings->address ?? '') }}</textarea>
    </div>
</div>
                                <div class="text-center mt-3">
                                    <button type="submit" class="btn btn-primary">Save</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection

@section('contentjs')
<script>
    $('.dropify').dropify({
        messages: {
            'default': 'Drag and drop an image here or click',
            'replace': 'Drag and drop or click to replace',
            'remove':  'Remove',
            'error':   'Ooops, something went wrong!'
        },
        error: {
            'fileExtension': 'Only JPG, JPEG, and PNG files are allowed.'
        }
    });
</script>
@endsection
