<form action="{{ route('notifications.staffnotificationsedit', $notifications->SNID) }}" method="POST">
    @csrf

    <div class="mb-3">
        <label class="form-label">Teacher Name</label>
        <select name="TTID" class="form-control select2"  required>
            <option value="">Select Teacher</option>
            @foreach($teachers as $teacher)
                <option value="{{ $teacher->TTID }}" {{ $notifications->TTID == $teacher->TTID ? 'selected' : '' }}>
                    {{ $teacher->Name }}
                </option>
            @endforeach
        </select>
    </div>

<div class="mb-3">
    <label>Title</label>
    <input type="text" name="Title"
           class="form-control"
           value="{{ old('Title', $notifications->Title ?? '') }}"
           required>
</div>


    <div class="mb-3">
        <label class="form-label">Message</label>
        <textarea name="Message" class="form-control" required>{{ old('Message', $notifications->Message ?? '') }}</textarea>
    </div>

    <div class="mb-3">
        <label class="form-label">Notification Date</label>
        <input type="date" name="Notfct_date" class="form-control" min = "{{ date('Y-m-d') }}"
               value="{{ old('Notfct_date', isset($notifications->Notfct_date) ? \Carbon\Carbon::parse($notifications->Notfct_date)->format('Y-m-d') : '') }}" 
               required>
    </div>

    <div class="modal-footer">
        <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success">Update Notification</button>
    </div>
</form>
