<form action="{{ route('notifications.addstudclassnotifications') }}" method="POST">
    @csrf
    <div class="row">
        <!-- Class Dropdown -->
        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">Class Name</label>
                <select name="Class" id="class" class="form-control" required>
                    <option value="">Select Class</option>
                    @foreach($classes as $class)
                        <option value="{{ $class->classId }}">{{ $class->className }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <!-- Division Dropdown -->
        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">Division</label>
                <select name="Sec" id="division" class="form-control" required>
                    <option value="">Select Division</option>
                </select>
            </div>
        </div>
        <!-- Student Dropdown -->
        <div class="col-md-12 mt-2">
            <div class="form-group">
                <label class="form-label">Student Name</label> <label class=" form-label text-danger"> (Optional)</label>
                <select name="SID[]" id="student" class="form-control select2" multiple>
                    <option value="">Select Student</option>
                </select>
            </div>
        </div>
        <!-- Title -->
        <div class="col-md-6">
            <div class="form-group">
                <label>Title</label>
                <input type="text" name="title" class="form-control" value="{{ old('title') }}" required>
            </div>
        </div>

        <!-- Notification Date -->
        <div class="col-md-6">
            <div class="form-group">
                <label>Notification Date</label>
                <input type="date" name="Notftn_date" class="form-control" value="{{ old('Notftn_date', date('Y-m-d')) }}"
                    min="{{ date('Y-m-d') }}" required>
            </div>
        </div>

        <!-- Message -->
        <div class="col-md-12">
            <div class="form-group">
                <label>Message</label>
                <textarea name="Message" class="form-control" required>{{ old('Message') }}</textarea>
            </div>
        </div>
    </div>

    <div class="mt-3 text-end">
        <button type="button" class="btn btn-primary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success btn-sm">Send Notification</button>
    </div>
</form>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script type="text/javascript">
$(document).ready(function() {

    
    $('#class').on('change', function() {
        var classId = $(this).val();              
        var divisionDropdown = $('#division');   
       
        divisionDropdown.html('<option value="">Loading...</option>');

        if (classId) {
            $.ajax({
                url: "{{ url('getDivisions') }}/" + classId, 
                type: "GET",
                dataType: "json",
                success: function(data) {
                    
                    divisionDropdown.empty();
                    divisionDropdown.append('<option value="">Select Division</option>');
                    $.each(data, function(index, division) {
                        divisionDropdown.append(
                            '<option value="' + division.name + '">' + division.name + '</option>'
                        );
                    });
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                    divisionDropdown.html('<option value="">Error loading divisions</option>');
                    alert('Failed to fetch divisions. Please try again.');
                }
            });
        } else {
            divisionDropdown.html('<option value="">Select Division</option>');
        }
    });

       $('#division').on('change', function() {
        var classId = $('#class').val();
        var secId = $(this).val();
        var studentDropdown = $('#student');
        studentDropdown.html('<option>Loading...</option>');

        if (classId && secId) {
            $.ajax({
                url: "{{ url('getStudents') }}/" + classId + "/" + secId,
                type: "GET",
                dataType: "json",
                success: function(data) {
                    studentDropdown.empty();
                    $.each(data, function(index, student) {
                        studentDropdown.append('<option value="' + student.SID + '">' + student.name + '</option>');
                    });
                },
                error: function() {
                    studentDropdown.html('<option value="">Error loading students</option>');
                }
            });
        } else {
            studentDropdown.html('<option value="">Select Class & Section first</option>');
        }
    });

});


</script>

