@extends('index')
@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                 
                    <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                        <h4 class="page-title">{{ $title }}</h4>
                        <div class="">
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="#">Admin</a></li>
                                <li class="breadcrumb-item active">Class List</li>
                            </ol>
                        </div>                            
                    </div>
                    
                    <div class="row justify-content-center">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center">
                                        <div class="col">                      
                                               @include('layouts.flashmessages')
                                            {{-- <h4 class="card-title">Class List</h4> --}}
                                                <a href="javascript:void(0)" onclick="basic_modal('', 'class/addclass', 'Add class')" class="waves-effect waves-light btn btn-outline btn-sm btn-primary float-end" title="Add" data-bs-toggle="modal" data-bs-target="#exampleModalDefault"><i class="fas fa-plus"></i> Add Class</i></a>  
                       
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body pt-0">
                                    <div class="table-responsive">
                                        <table class="table datatable" id="datatable_1" width="100%">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>SL No</th>
                                                    <th>Class Name</th>
                                                    <th>Stream Name</th>
                                                    <th>Location Name</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('contentjs')
<script>
$(document).ready(function () {
    $('#datatable_1').DataTable({
        processing: true,
        serverSide: true,
        searching: true,
        ajax: "{{ route('class.classlistview') }}",
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false, orderable: false },
            { data: 'className', name: 'className' },
            { data: 'streamName', name: 'streamName' },
            { data: 'locationName', name: 'locationName' },
            { data: 'action', name: 'action', searchable: false, orderable: false }
        ]
    });
    
});

</script>
@endsection
