@extends('index')
@section('content')
    <div class="page-wrapper">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        @include('layouts.flashmessages')
                        <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                            <h4 class="page-title">Dashboard</h4>
                            <div class="">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="#">Admin</a>
                                    </li>
                                    <li class="breadcrumb-item active">Dashboard</li>
                                </ol>
                            </div>                            
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-lg-7">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card  bg-welcome-img overflow-hidden">
                                    <div class="card-body">
                                        <div class="">                                            
                                            <h3 class="text-white fw-semibold fs-20 lh-base">Upgrade you plan for
                                            <br>Great experience</h3>
                                            <a href="#" class="btn btn-sm btn-danger">Upgarde Now</a>
                                            <img src="{{ asset('assets/images/extra/fund.png') }}" alt="" class=" mb-n4 float-end" height="107"> 
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card bg-globe-img">
                                    <div class="card-body">
                                        <div>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <span class="fs-16 fw-semibold">Balance</span>
                                                <form class="">
                                                    <select id="dynamic-select" name="example-select" data-placeholder="Select an option" data-dynamic-select>
                                                        <option value="1" data-img="{{ asset('assets/images/logos/m-card.png') }}">xx25</option>
                                                        <option value="2" data-img="{{ asset('assets/images/logos/ame-bank.png') }}">xx56</option>
                                                    </select>
                                                </form>
                                            </div>
                                            
                                            <h4 class="my-2 fs-24 fw-semibold">122.5692.00 <small class="font-14">BTC</small></h4>                                            
                                            <p class="mb-3 text-muted fw-semibold">
                                                <span class="text-success"><i class="fas fa-arrow-up me-1"></i>11.1%</span> Outstanding balance boost
                                            </p> 
                                            <button type="submit" class="btn btn-soft-primary">Transfer</button>
                                            <button type="button" class="btn btn-soft-danger">Request</button> 
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="row justify-content-center">
                            <div class="col-md-6 col-lg-6">
                                <div class="card bg-corner-img">
                                    <div class="card-body">
                                        <div class="row d-flex justify-content-center">
                                            <div class="col-9">
                                                <p class="text-muted text-uppercase mb-0 fw-normal fs-13">Total Teachers</p>
                                                <h4 class="mt-1 mb-0 fw-medium">{{ $teachers }}</h4>
                                            </div>
                                            
                                            <div class="col-3 align-self-center">
                                                <div class="d-flex justify-content-center align-items-center thumb-md border-dashed border-primary rounded mx-auto">
                                                    <i class="iconoir-group fs-22 align-self-center mb-0 text-primary"></i>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        
                                    </div>
                                    
                                </div>
                                
                            </div>
                            
                            <div class="col-md-6 col-lg-6">
                                <div class="card bg-corner-img">
                                    <div class="card-body">
                                        <div class="row d-flex justify-content-center">
                                            <div class="col-9">
                                                <p class="text-muted text-uppercase mb-0 fw-normal fs-13">Total Classes</p>
                                                <h4 class="mt-1 mb-0 fw-medium">{{ $classes }}</h4>
                                            </div>
                                            
                                            <div class="col-3 align-self-center">
                                                <div class="d-flex justify-content-center align-items-center thumb-md border-dashed border-info rounded mx-auto">
                                                    <i class="iconoir-book fs-22 align-self-center mb-0 text-info"></i>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        
                                    </div>
                                    
                                </div>
                                
                            </div>
                            
                            <div class="col-md-6 col-lg-6">
                                <div class="card bg-corner-img">
                                    <div class="card-body">
                                        <div class="row d-flex justify-content-center">
                                            <div class="col-9">
                                                <p class="text-muted text-uppercase mb-0 fw-normal fs-13">Total Divisions</p>
                                                <h4 class="mt-1 mb-0 fw-medium">{{ $divisions }}</h4>
                                            </div>
                                            
                                            <div class="col-3 align-self-center">
                                                <div class="d-flex justify-content-center align-items-center thumb-md border-dashed border-warning rounded mx-auto">
                                                    <i class="iconoir-puzzle fs-22 align-self-center mb-0 text-warning"></i>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        
                                    </div>
                                    
                                </div>
                                
                            </div>
                            
        
                            <div class="col-md-6 col-lg-6">
                                <div class="card bg-corner-img">
                                    <div class="card-body">
                                        <div class="row d-flex justify-content-center">
                                            <div class="col-9">
                                                <p class="text-muted text-uppercase mb-0 fw-normal fs-13">All Notifications</p>
                                                <h4 class="mt-1 mb-0 fw-medium">{{ $totalnotifications }}</h4>
                                            </div>
                                            
                                            <div class="col-3 align-self-center">
                                                <div class="d-flex justify-content-center align-items-center thumb-md border-dashed border-danger rounded mx-auto">
                                                    <i class="iconoir-bell-notification fs-22 align-self-center mb-0 text-danger"></i>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        
                                    </div>
                                    
                                </div>
                                
                            </div>        
                        </div>
                        
                    </div>
                    
                </div>
                
                <div class="row justify-content-center">
                    
                    <div class="col-md-12 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">                      
                                        <h4 class="card-title">Report</h4>                      
                                    </div>
                                    <div class="col-auto"> 
                                        <div class="dropdown">
                                            <a href="#" class="btn bt btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="icofont-calendar fs-5 me-1"></i> This Month<i class="las la-angle-down ms-1"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a class="dropdown-item" href="#">Today</a>
                                                <a class="dropdown-item" href="#">Last Week</a>
                                                <a class="dropdown-item" href="#">Last Month</a>
                                                <a class="dropdown-item" href="#">This Year</a>
                                            </div>
                                        </div>               
                                    </div>
                                </div>                                    
                            </div>
                            <div class="card-body pt-0">
                                <div id="reports" class="apex-charts pill-bar"></div>                                
                            </div>
                            
                        </div>
                        
                    </div>
                    
                    <div class="col-md-6 col-lg-3">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Cash Flow</h4>
                                    </div>
                                    
                                    <div class="col-auto">
                                        <div class="dropdown">
                                            <a href="#" class="btn bt btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="icofont-calendar fs-5 me-1"></i>
                                                Weekly<i class="las la-angle-down ms-1"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a class="dropdown-item" href="#">Today</a>
                                                <a class="dropdown-item" href="#">Weekly</a>
                                                <a class="dropdown-item" href="#">Monthly</a>
                                                <a class="dropdown-item" href="#">Yearly</a>
                                            </div>
                                        </div>
                                    </div> 
                                </div>
                            </div>
                            <div class="card-body pt-0">
                                <div id="cashflow" class="apex-charts"></div>
                                <div class="row">
                                    <div class="col-4">
                                        <div class="text-center">
                                            <p class="text-muted text-uppercase mb-0 fw-medium fs-13">Income</p>
                                            <h5 class="mt-1 mb-0 fw-medium">76%</h5>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="text-center">
                                            <p class="text-muted text-uppercase mb-0 fw-medium fs-13">Expense</p>
                                            <h5 class="mt-1 mb-0 fw-medium">23%</h5>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="text-center">
                                            <p class="text-muted text-uppercase mb-0 fw-medium fs-13">Other</p>
                                            <h5 class="mt-1 mb-0 fw-medium">1%</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class=" text-center mx-auto">
                                    <img src="{{ asset('assets/images/extra/rabit.png') }}" alt="" class="d-inline-block" height="105">
                                </div>
                                <div class="card-bg position-relative z-0">
                                    <div class="p-3 bg-primary-subtle rounded position-relative">                                    
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0 bg-primary-subtle text-primary thumb-lg rounded-circle">
                                                <i class="iconoir-bright-star fs-3"></i>
                                            </div>
                                            <div class="flex-grow-1 ms-2">
                                                <h6 class="my-0 fw-normal text-dark fs-13 mb-0">You have $1.53 remaining found over ...<a href="#" class="text-primary fw-medium mb-0 text-decoration-underline">View Details</a></h6>
                                                
                                            </div>
                                        </div>                                    
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">                      
                                        <h4 class="card-title">Notification Status</h4>                      
                                    </div>
                                </div>                                    
                            </div>
                            <div class="card-body pt-0">
                                <div class="table-responsive">
                                    <table class="table align-middle mb-0">
    <tbody>
        @foreach($latestNotifications as $notification)
            <tr>
                <td class="px-0">
                    <div class="d-flex align-items-center">
                        {{-- Icon based on type --}}
                        @if(isset($notification->TTID))
                            <i class="iconoir-user me-2 fs-4 text-primary"></i>
                        @else
                            <i class="iconoir-graduation-cap me-2 fs-4 text-success"></i>
                        @endif

                        {{-- Title and Message --}}
                        <div>
                            <h6 class="m-0 text-truncate">
                                {{ $notification->Title ?? '' }}
                            </h6>
                            <h6 class="m-0 text-truncate">
                                {{ $notification->title ?? '' }}
                            </h6>
                            <small class="text-muted">
                                {{ Str::limit($notification->Message, 40) }}
                            </small>
                        </div>
                    </div>
                </td>

                {{-- Type (Staff/Student) --}}
                <td class="px-0 text-end">
                    <span class="badge 
                        {{ isset($notification->TTID) ? 'bg-primary-subtle text-primary' : 'bg-success-subtle text-success' }}">
                        {{ isset($notification->TTID) ? 'Teacher' : 'Student' }}
                    </span>
                    <br>
                    <small class="text-muted">
                        {{ \Carbon\Carbon::parse($notification->Notfct_date ?? $notification->Notftn_date)->format('d M Y') }}
                    </small>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
                   
                                </div><!--end /div--> 
                                <hr class="hr-dashed">     
                                <div class="row">
                                    <div class="col-lg-6 text-center">
                                        <div class="p-2 border-dashed border-theme-color rounded">
                                            <p class="text-muted text-uppercase mb-0 fw-normal fs-13">Total Teacher Notifications</p>
                                            <h5 class="mt-1 mb-0 fw-medium text-success">{{ $staffCount }}</h5>
                                            
                                        </div>
                                    </div>
                                    <div class="col-lg-6 text-center">
                                        <div class="p-2 border-dashed border-theme-color rounded">
                                            <p class="text-muted text-uppercase mb-0 fw-normal fs-13">Total Student Notifications</p>
                                            <h5 class="mt-1 mb-0 fw-medium text-danger">{{ $studentCount }}</h5>
                                        </div>
                                    </div>
                                 </div>                      
                            </div> 
                        </div> 
                    </div>  
                </div>

            </div>
@endsection
            