<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Apicontroller;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::group(['middleware' => 'apicheck'], function () {
    Route::get('/', [Apicontroller::class, 'index']);
    Route::get('/count_row/{table_name?}', [Apicontroller::class, 'count_row']);
    Route::get('/del_row/{table_name?}/{id?}/{column_name?}', [Apicontroller::class, 'del_row']);
    Route::get('/tables_list', [Apicontroller::class, 'tables_list']);
    // Route::get('/tables_list', [Apicontroller::class, 'tables_list'])->middleware('apicheck');
    Route::get('/student_dashboard/{student_id?}', [Apicontroller::class, 'student_dashboard']);
    Route::get('/check_version', [Apicontroller::class, 'check_version']);
    Route::get('/update_version/{ver?}', [Apicontroller::class, 'update_version']);
    Route::get('/student_mark_view/{studentid?}', [Apicontroller::class, 'student_mark_view']);
    Route::get('/attend_exam_list/{studentid?}', [Apicontroller::class, 'attend_exam_list']);
    Route::get('/fee_view_by_id/{studentid?}', [Apicontroller::class, 'fee_view_by_id']);
    Route::get('/std_markview_by_ids/{studentid?}/{examid?}', [Apicontroller::class, 'std_markview_by_ids']);
    Route::get('/view_exam_list_teacher/{class?}/{section?}', [Apicontroller::class, 'view_exam_list_teacher']);
    Route::get('/student_curr_view/{studentid?}', [Apicontroller::class, 'student_curr_view']);
    Route::get('/get_student_subjects/{studentid?}', [Apicontroller::class, 'get_student_subjects']);
    Route::get('/view_mark_pdf/{id?}', [Apicontroller::class, 'view_mark_pdf']);
    Route::get('/static_periods', [Apicontroller::class, 'static_periods']);
    Route::get('/pwdResetOtp/{username}', [Apicontroller::class, 'pwdResetOtp']);
    Route::get('/studLeaveView/{stdentid}/{status?}', [Apicontroller::class, 'studLeaveView']);
    Route::get('/studLeaveViewTeacher/{class}/{section}', [Apicontroller::class, 'studLeaveViewTeacher']);
    Route::get('/studLeaveViewTeacherAll/{offset?}', [Apicontroller::class, 'studLeaveViewTeacherAll']);
    Route::get('/previlageTeacherStaff/{id?}', [Apicontroller::class, 'previlageTeacherStaff']);
    Route::get('/testPush', [Apicontroller::class, 'testPush']);




    Route::post('/otpValidateNewpwd', [Apicontroller::class, 'otpValidateNewpwd']);
    Route::post('/login', [Apicontroller::class, 'login']);
    Route::post('/get_table', [Apicontroller::class, 'get_table']);
    Route::post('/get_table_condition', [Apicontroller::class, 'get_table_condition']);
    Route::post('/get_student_list', [Apicontroller::class, 'get_student_list']);
    Route::post('/attendance_date_filter', [Apicontroller::class, 'attendance_date_filter']);
    // Route::post('/submit_attendance', [Apicontroller::class, 'submit_attendance']);
    Route::post('/submit_std_attendance', [Apicontroller::class, 'submit_std_attendance']);
    Route::post('/notification_manage', [Apicontroller::class, 'notification_manage']);
    Route::post('/notification_manage_teacher', [Apicontroller::class, 'notification_manage_teacher']);
    Route::post('/parent_att_view', [Apicontroller::class, 'parent_att_view']);
    Route::post('/class_sec_dropdown', [Apicontroller::class, 'class_sec_dropdown']);
    Route::post('/view_absenties', [Apicontroller::class, 'view_absenties']);
    Route::post('/present_view', [Apicontroller::class, 'present_view']);
    Route::post('/student_list', [Apicontroller::class, 'student_list']);
    Route::post('/student_list1', [Apicontroller::class, 'student_list1']);
    Route::post('/class', [Apicontroller::class, 'class']);
    Route::post('/section', [Apicontroller::class, 'section']);
    Route::post('/stud_notification', [Apicontroller::class, 'stud_notification']);
    Route::post('/submit_entry_exitpass', [Apicontroller::class, 'submit_entry_exitpass']);
    Route::post('/view_entry_exit_pass', [Apicontroller::class, 'view_entry_exit_pass']);
    Route::post('/view_pass', [Apicontroller::class, 'view_pass']);
    Route::post('/delete_pass', [Apicontroller::class, 'delete_pass']);
    Route::post('/notif_view', [Apicontroller::class, 'notif_view']);
    Route::post('/exams_by_classid', [Apicontroller::class, 'exams_by_classid']);
    Route::post('/stud_exams_by_ids', [Apicontroller::class, 'stud_exams_by_ids']);
    Route::post('/exam_mark_add', [Apicontroller::class, 'exam_mark_add']);
    Route::post('/notStatusUpdate', [Apicontroller::class, 'notStatusUpdate']);
    Route::post('/StudentNotifCount', [Apicontroller::class, 'StudentNotifCount']);
    Route::post('/stdApplyLeave', [Apicontroller::class, 'stdApplyLeave']);
    Route::post('/studLeaveStatus', [Apicontroller::class, 'studLeaveStatus']);
});

