<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PushMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function build()
    {
        return $this->view('maildata')
                    ->with([
                        'name' => $this->data['name'],
                        'static_otp' => $this->data['static_otp'],
                    ])
                    ->subject('Password Reset OTP');
    }
}

