<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ApiKeyCheck
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle($request, Closure $next)
    {
        if ($request->header('api-key')) {
            if ($request->header('api-key') == env('API_KEY')) {
                return $next($request);
            } else {
                return response()->json([
                'error' => 'api key mismatch'
                ], 401);
            }
        } else {
            return response()->json([
            'error' => 'header api key not fount'
            ], 404);
        }
    }
}
